theory Demo_Preliminaries imports
  Main
  "~~/src/HOL/Number_Theory/Primes"
  "~~/src/HOL/Eisbach/Eisbach"
begin

method transfer_prover' = (unfold relator_eq[symmetric]; transfer_prover)

lemma pretty_nat [code_post]: (* Pretty nat numerals for value *)
  "Suc 0 = 1"
  "Suc 1 = 2"
  "Suc (numeral n) = numeral (Num.inc n)"
by(simp_all add: Num.add_One)
declare Num.inc.simps [code_post]

unbundle lifting_syntax

lemmas [simp] = hd_map map_tl 

lemma wf_next_prime: "wf {(n + 1, n) | n :: nat. \<not> prime n}" (is "wf ?R")
proof(rule wfI_min)
  fix Q and x :: nat
  assume "x \<in> Q"
  from bigger_prime[of x] obtain p where "prime p" and "x < p" by blast
  show "\<exists>z \<in> Q. \<forall>y. (y, z) \<in> ?R \<longrightarrow> y \<notin> Q" using \<open>x < p\<close> \<open>x \<in> Q\<close>
  proof(induction d\<equiv>"p - x" arbitrary: x)
    case (Suc d)
    consider (step) "\<not> prime x" "x + 1 \<in> Q" "\<not> prime (x + 1)"
      | (trivial) "prime x \<or> x + 1 \<notin> Q \<or> prime (x + 1)" by auto
    then show ?case using \<open>x \<in> Q\<close>
    proof(cases)
      case step
      from \<open>Suc d = p - x\<close> have "d = p - (x + 1)" by auto
      moreover from \<open>\<not> prime x\<close> \<open>prime p\<close> \<open>x < p\<close> step
      have "x + 1 < p" by(cases "p = x + 1") auto
      ultimately show ?thesis using \<open>x + 1 \<in> Q\<close> by(rule Suc)
    qed auto
  qed simp
qed

end